/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   NAND FLash HAL Header File
::   Copyright   :   (C)2004-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __NANDFLASH_HAL_H
#define __NANDFLASH_HAL_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef struct S_NANDFlashDevice
{
    void (*pfFlashReset)(void);
    void (*pfFlashInit)(void);
    uint2 (*pfReadDeviceID)(void);
    uint2 (*pfWritePage)(uint1 const* in_pWriteData, uint4 in_Addr, uint4 in_uNumBytes);
    void (*pfReadPage)(uint1* out_pDataBuffer, uint4 in_uAddr, uint4 in_uNumBytes);
    uint2 (*pfWritePageSpare)(uint1 const* in_pWriteData, uint4 in_Addr, uint4 in_uNumBytes);
    void (*pfReadPageSpare)(uint1* out_pDataBuffer, uint4 in_Addr, uint4 in_uNumBytes);
    uint2 (*pfEraseBlock)(uint4 in_Addr);
    NativeBool (*pfIsBlockFlaggedBadByManufacturer)(uint4 in_uBlock);

} S_NANDFlashDevice;

#pragma pack()

/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/


#endif /* __NANDFLASH_HAL_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
